clear all; close all; %Clear all variables D:\Data\CCK-Cre_sensor-AC_Virus-MGB-220815and close all figures
BlockDir=uigetdir('E:\dATA\PFC and BLA_V\RAW\Fiber Photometry\mDlx-Gcamp-TS\laser Day0'); %Get folder name
cd(BlockDir); %Change directory to photometry folder
[Tank,Block,~]=fileparts(cd); %List full directory for Tank and Block
SDKPATH = 'C:\TDT\TDTMatlabSDK\TDTSDK\TDTbin2mat';
addpath(genpath(SDKPATH));
data=TDTbin2mat([Tank,'\',Block]) %Use TDT2Mat to extract data.

%% SYNAPSE- Extract Relevant Data from Data file
%Create Variables for each Photometry Channel and timestamps
Ch473=data.streams.x473G.data; %sensor
Ch405=data.streams.x405G.data; %Isosbestic Control
Ts = ((1:numel(data.streams.x473G.data(1,:))) / data.streams.x405G.fs)'; % Get Ts for samples based on Fs
Fs=data.streams.x473G.fs; %Variable for Fs

%% Behavioral Events
%Burst=[];Burst_R=[];
Trial=[];%Beh=[];
%Beh=data.epocs.AmA_; %Make a variable with all behavioral data.

%find the rows of data with each specific bit and then extract the
%timestamp for those specific bits. Copy and change these lines for any
%bits that you need data from.
%Burst=Beh.onset(Beh.data(:,1)==10000,:); %提出每个burst的onset
%Burst=Beh.onset(:,1);
%Burst(21)=[];
%Burst_R=reshape(Burst,10,[]);%通过Burst数组重构来提出每个trial的第一个burst
Trial=xlsread('E:\dATA\PFC and BLA_V\RAW\Fiber Photometry\mDlx-Gcamp-TS\laser Day0\mDlxG-Day0-laser-M5R\Trail.csv');%提出每个trial的onset
%不够10个burst时：
%Trial=Burst;

%load CSV for events
%events = xlsread('D:\Data\C57_shRNA_antiCCK-MGB_sensor-AC-230404\HFES+DHPG+HFES_30min05s-drop_LIXIAO_HFS-230404-191915\EventData_drop DHPG.xlsx');
%Trial=events(:,2);


%% PETH;
%Find Time=0 for the event within the photometry data
    CSidx=[];
    for i=1:length(Trial)
        [MinVal, CSidx(i,1)]=min(abs(Ts(:,1)-Trial(i)));%min函数可以返回最小值的index,放在CSidx(i,1)   
    end


%% Create Window Size 
    PreWind=round(5*Fs);
    PostWind=round(10*Fs);
    BaselineWind=round(5*Fs);
    CS405=[];CSTS=[];CS473=[];
    a_std=[];b_mean=[];
   for  i=1:length(CSidx)
       
            if CSidx(i)+PostWind <= length(Ch473) %在时间范围内的满足PreWind+PostWind的trial
                
            %Obtain data within baseline and event window for 405 and 490 channels.
            
            CSBL_473(i,:)=Ch473((CSidx(i)-BaselineWind):CSidx(i)); 
            CSBL_405(i,:)=Ch405((CSidx(i)-BaselineWind):CSidx(i));
            CS405(i,:)=Ch405((CSidx(i)-PreWind):(CSidx(i)+PostWind)); 
            CS473(i,:)=Ch473((CSidx(i)-PreWind):(CSidx(i)+PostWind));
            
            %Smooth to eliminate high frequency noise.
            
            %CSBL_473(i,:)=smooth(CSBL_473(i,:),0.002,'lowess');  %Was 0.002- DJB
            %CSBL_405(i,:)=smooth(CSBL_405(i,:),0.002,'lowess');
            %CS473(i,:)=smooth(CS473(i,:),0.002,'lowess');  %Was 0.002- DJB
            %CS405(i,:)=smooth(CS405(i,:),0.002,'lowess');
            
            %smooth by movmean
            %CSBL_473(i,:)=movmean(CSBL_473(i,:),[1*Fs,1*Fs]);%前后各1s做滑动平均
            %CSBL_405(i,:)=movmean(CSBL_405(i,:),[1*Fs,1*Fs]);
            %CS405(i,:)=movmean(CS405(i,:),[1*Fs,1*Fs]);
            
            
            
           
            % Scale and fit data
            %Polyfit
              %blsbase(i,:)=polyfit(CSBL_405(i,:),CSBL_473(i,:),1);
              %Y_Fit=blsbase(i,1).*CS405+blsbase(i,2);
            
          %Std,mean
             a_std(i,1)=std(CSBL_473(i,:))/std(CSBL_405(i,:));
             b_mean(i,1)=mean(CSBL_473(i,:))-mean(a_std(i,1).*CSBL_405(i,:));
             Y_Fit(i,:)=a_std(i,1).*CS405(i,:)+b_mean(i,1);
          
          %Good idea
              %blsbase(i,:)=polyfit(CSBL_405(i,:)-mean(CSBL_405(i,:)),CSBL_473(i,:)-mean(CSBL_473(i,:)),1);
              %Y_Fit(i,:)=blsbase(i,1).*(CS405(i,:)-mean(CSBL_405(i,:)))+mean(CSBL_473(i,:));
            
            % delta F/F
            DF_F(i,:)=(CS473(i,:)-Y_Fit(i,:))./(Y_Fit(i,:)); 
            
            else
            %如果最后一个trial不够区间长度：    
                PostWind_last=0.9*(length(Ch473)-CSidx(i));%PostWind是剩下的时间长度的90%
                % 只有一个trial,且不满足postwind时，bining那也要改，
                % 因为这时time列的bining用的还是前面的pre+postwind,不是pre+postwind_last，而数据列是pre+postwind_last去bining
                % 然而不只有个trial的时候，最后那列长度不够的数据空白的地方是会被补0的，
                % 最后不够的那列也可以和时间列一起用pre+postwind去bining,所以每列都是对齐的
                
                lastTrial=i;
           %最后一个trial的baseline和之前一样     
               CSBL_473(i,:)=Ch473((CSidx(i)-BaselineWind):CSidx(i)); 
               CSBL_405(i,:)=Ch405((CSidx(i)-BaselineWind):CSidx(i));
           %最后一行长度变短了，直接填填不上，一个一个循环写入   
               s=(CSidx(lastTrial)-PreWind);
               for c=1:PreWind+PostWind_last+1
                   CS405(lastTrial,c)=Ch405(s); 
                   CS473(lastTrial,c)=Ch473(s);
                   s=s+1;
               end
               
               %Smooth to eliminate high frequency noise.
            
            %CSBL_473(i,:)=smooth(CSBL_473(i,:),0.002,'lowess');  %Was 0.002- DJB
            %CSBL_405(i,:)=smooth(CSBL_405(i,:),0.002,'lowess');
            %CS473(i,:)=smooth(CS473(i,:),0.002,'lowess');  %Was 0.002- DJB
            %CS405(i,:)=smooth(CS405(i,:),0.002,'lowess');
            
            %smooth by movmean
            %CSBL_473(i,:)=movmean(CSBL_473(i,:),[1*Fs,1*Fs]);%前后各1s做滑动平均
            %CSBL_405(i,:)=movmean(CSBL_405(i,:),[1*Fs,1*Fs]);
            %CS405(i,:)=movmean(CS405(i,:),[1*Fs,1*Fs]);
            
               
               
               % Scale and fit data
               
               %Polyfit
                 %blsbase(i,:)=polyfit(CSBL_405(i,:),CSBL_473(i,:),1);
                 %Y_Fit=blsbase(i,1).*CS405+blsbase(i,2);
              %Std,mean
              a_std(i,1)=std(CSBL_473(i,:))/std(CSBL_405(i,:));
              b_mean(i,1)=mean(CSBL_473(i,:))-mean(a_std(i,1).*CSBL_405(i,:));
              Y_Fit(i,:)=a_std(i,1).*CS405(i,:)+b_mean(i,1);
         
              %Good idea
              %blsbase(i,:)=polyfit(CSBL_405(i,:)-mean(CSBL_405(i,:)),CSBL_473(i,:)-mean(CSBL_473(i,:)),1);
              %Y_Fit(i,:)=blsbase(i,1).*(CS405(i,:)-mean(CSBL_405(i,:)))+mean(CSBL_473(i,:));
           
              
            % delta F/F
               DF_F(i,:)=(CS473(i,:)-Y_Fit(i,:))./(Y_Fit(i,:)); 
                
              end   
   end

  %% Binning   

            bin=100;
            
            time_bin=[];DF_F_bin=[];time_bin_last=[];
           
            CSTS=(-PreWind:PostWind);
            % 只有一个trial,且不满足postwind时，用下面那行
            %CSTS=(-PreWind:PostWind_last);
          
                
                for n=1:bin:length(CSTS)
                  if n+bin <= length(CSTS)
                       time_bin(1,end+1)=median(CSTS(n:n+bin));
                       DF_F_bin(:,end+1)=median(DF_F(:,n:n+bin),2);
                       
                  else
                  end
                end
            
            %Binning之后最后那个不满足postwind的Trial的最后一个点(-1前的一个点）是不准的，可以删掉
            if CSidx(end)+PostWind > length(Ch473)
               t0=lastTrial-1;
               CSTS_last=(-PreWind:PostWind_last);
            for b=1:bin:length(CSTS_last)
                if b+bin<=length(CSTS_last)
                time_bin_last(1,end+1)=median(CSTS_last(b:b+bin));
                else
                end
            end
            else
           end 
            
 %% Output 原始deltaF as csv

         filename= 'delta F_60+60_base20s_movmean1+1_bs20s_HFES in MGB.xlsx';
         list_DF=[transpose(CSTS./Fs) transpose(DF_F.*100)];
         writematrix(list_DF,filename)

          %output Y_fit
         %filename= 'Y_Fit-60+60s_baseline20s_5 trials_std_movmean1+1.csv';
         %list_Y_Fit=[transpose(CSTS./Fs) transpose(Y_Fit)];
         %writematrix(list_Y_Fit,filename)
         
         %output signal 473/405
         %filename= 'CS473_movmean1+1.csv';
         %list_CS473=[transpose(CSTS./Fs) transpose(CS473)];
         %writematrix(list_CS473,filename)
         
         %filename= 'CS405_movmmean1+1.csv';
         %list_CS405=[transpose(CSTS./Fs) transpose(CS405)];
         %writematrix(list_CS405,filename)
         
       
%% Output 用中位数压缩过的delta F as csv

         filename= 'delta F_bin_medium-60+60s_baseline120s_movmean_1+1_HFES in MGB.xlsx';
         list_mDF=[transpose(time_bin./Fs) transpose(DF_F_bin.*100)];
         if CSidx(end)+PostWind <= length(Ch473)
             row=[0:size(DF_F_bin,1)];
         else
             for q=1:length(time_bin_last)%把最后一个trial的时间逐个写在最后一列
             list_mDF(q,size(DF_F_bin,1)+2)= time_bin_last(1,q)./Fs;
             end
             row=[0:size(DF_F_bin,1)+1];
         end
         list_mDF=[row;list_mDF];
         writematrix(list_mDF,filename)
         
        
 %% Plot
          
    [j,k]=size(DF_F_bin);
    
    for m =1:j-1
        
        figure
        plot(time_bin./Fs,DF_F_bin(m,:).*100,'LineWidth',1)
        
        title('Delta_F', 'Fontsize', 15);
        xlabel('Time(s)', 'FontSize',15)
        ylabel('% \Delta F/F','fontsize', 15);
       
    end
   if CSidx(end)+PostWind > length(Ch473)
       figure
       plot(time_bin_last./Fs,DF_F_bin(j,1:size(time_bin_last,2)).*100,'LineWidth',1)
   else
       figure
       plot(time_bin./Fs,DF_F_bin(j,:).*100,'LineWidth',1)
   end